﻿/*	VERSION:	1.2

USAGE:
	code = make_cheatCode("replay");

	code.rightKey = function(pressed_char, match_char){
		trace(pressed_char+" is right");
	}// rightKey()
	
	code.wrongKey = function(pressed_char, match_char){
		trace(pressed_char+" is wrong, need "+match_char);
	}// wrongKey()
	
	code.done = function(code_str){
		trace('"'+code_str+'" complete');
	}// done()
	
	onUnload = function(){
		code.onUnload();
	}// onUnload()
*/
make_cheatCode = function( code ){
	var output = {};
	var code_str = code.toUpperCase();
	var index = 0;
	
	output.onKeyDown = function(){
		var pressed_code = Key.getCode();
		var pressed_char = String.fromCharCode( pressed_code ).toUpperCase();
		var match_char = code_str.charAt(index);
		if(match_char == pressed_char){
			index++;
			output.rightKey( pressed_char, match_char );
			if(index == code_str.length){
				index = 0;
				output.done( code );
				Key.removeListener( key_react );
			}// if:  pressed last code character
		}// if:  match
		else
		{// if:  wrong key pressed
			index = 0;
			output.wrongKey( pressed_char, match_char );
		}// if:  wrong key pressed
	}// onKeyDown()
	Key.addListener( output );
	output.onUnload = function(){
		Key.removeListener( output );
	}// onUnload()
	
	return output;
}// make_cheatCode()